/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQuickSort;

public class VWMapNameUtil {
    protected VWMapCache m_mapCache = null;

    public VWMapNameUtil(VWMapCache mapCache) {
        this.m_mapCache = mapCache;
    }

    public String getPrettyName(String mapName) {
        String prettyName = mapName;
        if (mapName != null && mapName.length() > 0) {
            if (this.m_mapCache.isMapExist(mapName, true) && VWStringUtils.compare(mapName, VWResource.s_none) != 0 && !this.m_mapCache.isEditable(mapName)) {
                prettyName = VWResource.s_readOnlyLabel.toString(mapName);
            } else if (VWStringUtils.compare(mapName, "Workflow") == 0) {
                prettyName = VWResource.s_mainMapLabel.toString(mapName);
            }
        }
        return prettyName;
    }

    public String getPrettyName(VWMap map) {
        String prettyName = null;
        if (map != null) {
            prettyName = this.getPrettyName(map.getName());
        }
        return prettyName;
    }

    public String getPrettyName(VWMapDefinition mapDef) {
        String prettyName = null;
        if (mapDef != null) {
            prettyName = this.getPrettyName(mapDef.getName());
        }
        return prettyName;
    }

    public String[] getPrettyMapNames(String[] wfMapNames) {
        try {
            if (wfMapNames != null) {
                for (int i = 0; i < wfMapNames.length; ++i) {
                    if (VWStringUtils.compare(wfMapNames[i], "Workflow") == 0) {
                        if (i <= 0) continue;
                        wfMapNames[i] = wfMapNames[0];
                        wfMapNames[0] = this.getPrettyName("Workflow");
                        continue;
                    }
                    wfMapNames[i] = this.getPrettyName(wfMapNames[i]);
                }
                VWQuickSort qs = new VWQuickSort(wfMapNames, 0);
                qs.sort(1, wfMapNames.length - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return wfMapNames;
    }

    public VWMap getMap(VWMapDefinition mapDef) {
        VWMap vwMap;
        String mapName;
        if (mapDef != null && this.m_mapCache != null && this.m_mapCache.isMapExist(mapName = mapDef.getName(), true) && (vwMap = this.m_mapCache.get(mapName, true)) != null && vwMap.getMapDefinition().equals(mapDef)) {
            return vwMap;
        }
        return null;
    }
}

